# Installation d'Anaconda sur un Pc linux





Sous linux, un logiciel est distribué sous la forme d’un paquet.

## Un paquet, qu'est ce que c'est ?
Un paquet est une archive contenant les fichiers et les instructions nécessaires à l’installation d’un logiciel sur un système d’exploitation (on y trouve des fichiers exécutables, des fichiers de configuration, des fichiers de documentation, des dépendances logicielles, des scripts de pré/post installation, des scripts de pré/post désinstallation…).

Le format d’un paquet dépend de la distribution Linux que vous utilisez:
 
- Debian et ses dérivés (Ubuntu, Tails…) : paquets Debian, extension .deb.
- Red Hat Enterprise Linux et ses dérivés (Fedora, CentOS…) : paquets RPM (RedHat Package Manager), extension .rpm.

Pour installer un logiciel comme Firefox sur votre système d’exploitation Ubuntu, 
vous devez donc installer le paquet Debian correspondant:
firefox_60.0.1-5_amd64.deb (pour Firefox v60.0.1, x86-64). 
Cela ressemble au programme d’installation .exe que vous avez peut-être l’habitude d’utiliser sur Windows.




## Comment faire pour installer un paquet ?

### Utiliser un gestionnaire de paquets

Un gestionnaire de paquets, c’est un outil qui permet d’installer des logiciels, 
de les désinstaller et de les mettre à jour.

Son fonctionnement est simple : un gestionnaire de paquets est connecté à un ou plusieurs dépôts 
dans lesquels sont stockés des paquets. 
A partir de là, il est possible de récupérer des paquets depuis ces dépôts 
pour les installer sur notre système. On peut voir ça comme un magasin d’applications à
 l’instar du Microsoft Store ou de Google Play.

L’avantage comparé à Windows est qu’il n’est plus nécessaire de chercher 
à droite à gauche le programme d’installation du logiciel que l’on souhaite installer ou mettre à jour.
 
Sur Linux, tous les logiciels sont centralisés dans des dépôts accessibles via le gestionnaire de paquets, 
ce qui permet de les installer et de les mettre à jour très facilement avec une simple commande!

Sur Debian/Ubuntu, il faudra utiliser dpkg (gestionnaire de paquets de bas niveau) ou APT 
(gestionnaire de paquets de haut niveau, basé sur dpkg).





### Quelles différences entre dpkg et APT  ?
 
Pour fonctionner, un paquet a très souvent besoin qu’un ou plusieurs autres paquets 
soient installés sur le système. On dit alors qu’il a des dépendances.

Lorsque vous tentez d’installer un paquet avec dpkg, celui-ci vérifie 
les dépendances du paquet et se refuse à l’installer si les dépendances ne sont pas satisfaites 
(si elles ne sont pas installées sur le système). Le « problème », 
c’est que dpkg ne vous aidera pas à trouver ces dépendances 
ni à les installer contrairement à APT qui lui cherchera, 
trouvera et installera automatiquement toutes les dépendances nécessaires 
à l’installation du paquet! C’est pourquoi il est recommandé d’utiliser APT.

L’installation, la mise à jour et la suppression d’un paquet via APT peut se faire de deux manières différentes 

- via l’émulateur de terminal 
- via les interfaces graphiques Synaptic et GNOME Software.



### Installation d'Anaconda ? 
Nous allons installer Anaconda sur votre machine via l'émulateur en ligne de commande. 
La dernière version de ce logiciel n'est pas disponible dans les dépots. 
Nous allons donc suivre une procédure particulière pour l'installation.

- Ouvrir un terminal et taper la commande suivante : 
`wget https://repo.anaconda.com/archive/Anaconda3-2019.07-Linux-x86_64.sh`. 
Le script se télécharge sur votre ordinateur.

![](img_executer/wget.png)

!!! Note 

    [wget](https://doc.ubuntu-fr.org/wget):
    
    Wget est un programme en ligne de commande non interactif de téléchargement 
    de fichiers depuis le Web. 
    Il supporte les protocoles HTTP, HTTPS et FTP ainsi que le téléchargement au travers des proxies HTTP. 

- lancer ce script par `sh Anaconda3-2019.07-Linux-x86_64.sh` puis se laisser guider.

### Lancer Anaconda

!!! Important
    Dans un terminal entrez : anaconda-navigator
